<?php declare(strict_types=1);

namespace VideoAISoftware\Migration;

use Doctrine\DBAL\Connection;
use Shopware\Core\Framework\Log\Package;
use Shopware\Core\Framework\Migration\MigrationStep;

/**
 * @internal
 */
#[Package('core')]
class Migration1729602215MwsVaisProductAiVideo extends MigrationStep
{
    public function getCreationTimestamp(): int
    {
        return 1729602215;
    }

    public function update(Connection $connection): void
    {
        # TODO: Add language_id in new migration when implemented in middleware

        $query = <<<'SQL'
            CREATE TABLE mws_vais_product_ai_video (
                product_id BINARY(16) NOT NULL, 
                media_id BINARY(16) NOT NULL, 
                product_version_id BINARY(16) DEFAULT NULL,
                published tinyint default 0,
                created_at DATETIME NOT NULL, 
                updated_at DATETIME DEFAULT NULL, 
                PRIMARY KEY(product_id, media_id),
                FOREIGN KEY (product_id, product_version_id) references product(id, version_id) on DELETE CASCADE,
                FOREIGN KEY (media_id) references media(id) on DELETE CASCADE,
                KEY `mws_vais_product_ai_video.fk.product_id_media_id` (product_id, media_id)
            ) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB;
        SQL;

        $connection->executeStatement($query);
    }

    public function updateDestructive(Connection $connection): void
    {
        // Add destructive update if necessary
    }
}
