<?php declare(strict_types=1);

namespace VideoAISoftware\Migration;

use Doctrine\DBAL\Connection;
use Shopware\Core\Framework\Log\Package;
use Shopware\Core\Framework\Migration\MigrationStep;

/**
 * @internal
 */
#[Package('core')]
class Migration1730277452MwsVaisProductVideoConfig extends MigrationStep
{
    public function getCreationTimestamp(): int
    {
        return 1730277452;
    }

    public function update(Connection $connection): void
    {
        $query = <<<'SQL'
            ALTER TABLE mws_vais_product_video_config DROP FOREIGN KEY `fk.mwsvais.product_id`;

            ALTER TABLE mws_vais_product_video_config ADD 
                video_script_state VARCHAR(255) DEFAULT NULL, 
                ADD video_script_error JSON DEFAULT NULL, 
                ADD video_script JSON DEFAULT NULL;

            ALTER TABLE mws_vais_product_video_config 
                ADD CONSTRAINT `fk.mwsvais.product_id` 
                    FOREIGN KEY (product_id, product_version_id)
                    REFERENCES product (id, version_id) 
                    ON UPDATE CASCADE 
                    ON DELETE CASCADE;
SQL;

        $connection->executeStatement($query);
    }

    public function updateDestructive(Connection $connection): void
    {
        // Add destructive update if necessary
    }
}
