<?php declare(strict_types=1);

namespace VideoAISoftware\Migration;

use Doctrine\DBAL\Connection;
use Shopware\Core\Defaults;
use Shopware\Core\Framework\Log\Package;
use Shopware\Core\Framework\Migration\MigrationStep;
use Shopware\Core\Framework\Uuid\Uuid;
use Shopware\Core\System\SystemConfig\SystemConfigDefinition;

/**
 * @internal
 */
#[Package('core')]
class Migration1730277453DefaultSystemConfigSettings extends MigrationStep
{
    public function getCreationTimestamp(): int
    {
        return 1730277453;
    }

    public function update(Connection $connection): void
    {
        $connection->executeStatement(<<<SQL
            INSERT INTO system_config (id, configuration_key, configuration_value, created_at)
            VALUES (
                    :id,
                    'VideoAISoftware.config.useProductName',
                    '{"_value": true}',
                    :createdAt
            )
            ON DUPLICATE KEY UPDATE 
                configuration_value = '{"_value": true}'
        SQL, [
            'id' => Uuid::fromHexToBytes($this->getConfigId($connection, 'VideoAISoftware.config.useProductName') ?? Uuid::randomHex()),
            'createdAt' => (new \DateTime())->format(Defaults::STORAGE_DATE_TIME_FORMAT)
        ]);

        $connection->executeStatement(<<<SQL
            INSERT INTO system_config (id, configuration_key, configuration_value, created_at)
            VALUES (
                    :id,
                    'VideoAISoftware.config.useProductDescription',
                    '{"_value": true}',
                    :createdAt
            )
            ON DUPLICATE KEY UPDATE 
                configuration_value = '{"_value": true}'
        SQL, [
            'id' => Uuid::fromHexToBytes($this->getConfigId($connection, 'VideoAISoftware.config.useProductDescription') ?? Uuid::randomHex()),
            'createdAt' => (new \DateTime())->format(Defaults::STORAGE_DATE_TIME_FORMAT)
        ]);
    }

    public function updateDestructive(Connection $connection): void
    {
        // Add destructive update if necessary
    }

    /**
     * @param Connection $connection
     * @param string $configurationKey
     * @return false|string
     * @throws \Doctrine\DBAL\Exception
     */
    private function getConfigId(Connection $connection, string $configurationKey)
    {
        $id = $connection->createQueryBuilder()
            ->select('lower(hex(id))')
            ->from(SystemConfigDefinition::ENTITY_NAME)
            ->where('configuration_key = :configurationKey')
            ->setParameter('configurationKey', $configurationKey)
            ->fetchOne();

        if ($id === false) return null;

        return $id;
    }
}
