<?php declare(strict_types=1);

namespace VideoAISoftware\Migration;

use Doctrine\DBAL\Connection;
use Shopware\Core\Framework\Log\Package;
use Shopware\Core\Framework\Migration\MigrationStep;

/**
 * @internal
 */
#[Package('core')]
class Migration1731484118MwsVaisBulkMeta extends MigrationStep
{
    public function getCreationTimestamp(): int
    {
        return 1731484118;
    }

    public function update(Connection $connection): void
    {
        $query = <<<'SQL'
            CREATE TABLE mws_vais_bulk_meta (
                bulk_id BINARY(16) NOT NULL, 
                product_id BINARY(16) NOT NULL, 
                product_version_id BINARY(16) NOT NULL, 
                bulk_state VARCHAR(255) NOT NULL, 
                context LONGBLOB NULL,
                script_and_video TINYINT(1) DEFAULT 0 NOT NULL,
                created_at DATETIME NOT NULL, 
                updated_at DATETIME DEFAULT NULL, 
                PRIMARY KEY(bulk_id, product_id, product_version_id),
                CONSTRAINT `fk.mws_vais_bulk_meta.product_id`
                    FOREIGN KEY (product_id, product_version_id) 
                    REFERENCES product (id, version_id) 
                    ON UPDATE CASCADE 
                    ON DELETE CASCADE
        ) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB;
        SQL;

        $connection->executeStatement($query);
    }

    public function updateDestructive(Connection $connection): void
    {
        // Add destructive update if necessary
    }
}
