<?php declare(strict_types=1);

namespace VideoAISoftware\Migration;

use Doctrine\DBAL\Connection;
use Shopware\Core\Framework\Log\Package;
use Shopware\Core\Framework\Migration\MigrationStep;

/**
 * @internal
 */
#[Package('core')]
class Migration1731934189MwsVaisProductAiVideo extends MigrationStep
{
    public function getCreationTimestamp(): int
    {
        return 1731934189;
    }

    public function update(Connection $connection): void
    {
        $query = <<<'SQL'
            ALTER TABLE mws_vais_product_ai_video ADD parent_id BINARY(16) DEFAULT NULL;

            ALTER TABLE mws_vais_product_ai_video ADD CONSTRAINT `fk.mws_vais_product_ai_video.parent_id` FOREIGN KEY (parent_id) 
                    REFERENCES mws_vais_product_ai_video (id) ON UPDATE CASCADE ON DELETE CASCADE;
        SQL;

        $connection->executeStatement($query);
    }

    public function updateDestructive(Connection $connection): void
    {
        // Add destructive update if necessary
    }
}
