<?php declare(strict_types=1);

namespace VideoAISoftware\Migration;

use Doctrine\DBAL\Connection;
use Shopware\Core\Framework\Log\Package;
use Shopware\Core\Framework\Migration\MigrationStep;

/**
 * @internal
 */
#[Package('core')]
class Migration1747311144DeleteUnsupportedConfigMedia extends MigrationStep
{
    public function getCreationTimestamp(): int
    {
        return 1747311144;
    }

    public function update(Connection $connection): void
    {
        $connection->executeStatement(<<<SQL
            delete cm from mws_vais_product_video_config_media cm
                inner join product_media pm on pm.id = cm.product_media_id
                inner join media m on pm.media_id = m.id
            where m.mime_type not in ('image/jpeg', 'image/png', 'image/svg+xml', 'image/webp')
        SQL);
    }
}
