const ApiService = Shopware.Classes.ApiService;

export default class FetchUsageStatisticsService extends ApiService {
    constructor(httpClient, loginService, apiEndpoint = 'usage-statistics') {
        super(httpClient, loginService, apiEndpoint);
    }

    getUsageStatistics(params) {
        const headers = this.getBasicHeaders();

        return this.httpClient.get(
            `${this.getApiBasePath()}/get-usage-statistics`,
            {
                headers,
                params
            }
        ).then((response) => {
            return ApiService.handleResponse(response);
        }).catch((error) => {
            console.error('Error retrieving usage statistics:', error);
            throw error;
        });
    }
}
