<?php declare(strict_types=1);

namespace VideoAISoftware\Migration;

use Doctrine\DBAL\Connection;
use Shopware\Core\Defaults;
use Shopware\Core\Framework\Log\Package;
use Shopware\Core\Framework\Migration\MigrationStep;
use Shopware\Core\Framework\Uuid\Uuid;

/**
 * @internal
 */
#[Package('core')]
class Migration1739186669AddRemoveBackgroundAutomatically extends MigrationStep
{
    public function getCreationTimestamp(): int
    {
        return 1739186669;
    }

    public function update(Connection $connection): void
    {
        $connection->executeStatement(<<<SQL
            ALTER TABLE mws_vais_product_video_config ADD COLUMN remove_background_automatically TINYINT(1) null;
        SQL);

        $connection->executeStatement(<<<SQL
            INSERT IGNORE INTO system_config (id, configuration_key, configuration_value, created_at) VALUES ('id','VideoAISoftware.config.removeBackgroundAutomatically', '{"_value": true}', ':createdAt')
        SQL, [
            'id' => Uuid::randomBytes(),
            'createdAt' => (new \DateTime())->format(Defaults::STORAGE_DATE_TIME_FORMAT)
        ]);
    }
}
