import template from './mwsvais-api-token-validation-button.html.twig';
import './mwsvais-api-token-validation-button.scss'

const {Component, Mixin} = Shopware;

Component.register('mwsvais-api-token-validation-button', {
    template,
    props: ['label'],
    inject: ['apiTest', 'fetchUsageStatistics'],

    mixins: [
        Mixin.getByName('notification')
    ],

    data() {
        return {
            isLoading: false,
            isSaveSuccessful: false,
        };
    },

    computed: {
        pluginConfig() {
            let $parent = this.$parent;

            while ($parent.actualConfigData === undefined) {
                $parent = $parent.$parent;
            }

            return $parent.actualConfigData.null;
        },
        apiKey() {
            return this.pluginConfig ? this.pluginConfig['VideoAISoftware.config.apiKey'] : '';
        }
    },


    methods: {
        saveFinish() {
            this.isSaveSuccessful = false;
        },

        async check() {

            try {
                this.isLoading = true;
                await this.apiTest.check({apiKey: this.apiKey})

                this.isSaveSuccessful = true;
                this.createNotificationSuccess({
                    title: this.$tc('mwsvais.apiTestButton.title'),
                    message: this.$tc('mwsvais.apiTestButton.success')
                });

                // Lade die Nutzungstatistiken, nachdem der Token validiert wurde
                if (this.usageStatisticsComponent) {
                    this.usageStatisticsComponent.loadUsageStatistics(); // Aufruf der Methode in der usage statistics Komponente
                }

                setTimeout(() => {
                    this.isSaveSuccessful = false
                }, 5000)

            } catch (error) {
                this.createNotificationError({
                    title: this.$tc('mwsvais.apiTestButton.title'),
                    message: this.$tc('mwsvais.apiTestButton.error') + `: ${error.message}`
                });
            } finally {
                this.isLoading = false;
            }
        }
    }
});