import template from './mwsvais-sw-product-image.html.twig';

import './style.scss';

const { Component } = Shopware;

Component.register('mwsvais-product-image', {
    template,

    props: {
        mediaId: {
            type: String,
            required: true,
        },

        productMediaId: {
            type: String,
            required: true,
        },

        /**
         * @experimental stableVersion:v6.7.0 feature:SPATIAL_BASES
         */
        isSpatial: {
            type: Boolean,
            required: false,
            default: false,
        },

        /**
         * @experimental stableVersion:v6.7.0 feature:SPATIAL_BASES
         */
        isArReady: {
            type: Boolean,
            required: false,
            default: false,
        },

        isSelected: {
            type: Boolean,
            required: false,
            default: false
        }
    },

    computed: {
        productImageClasses() {
            return {
                'is--placeholder': this.isPlaceholder,
                'is--spatial': this.isSpatial,
            };
        },
    },

    methods: {
        toggleSelect() {
            if (this.isPlaceholder) return;

            if(this.isSelected) this.$emit('imageDeselect', this.productMediaId);
            else this.$emit('imageSelect', this.productMediaId);
        }
    }
});