import deDE from './snippet/de-DE.json';
import enGB from './snippet/en-GB.json';
import './components/mwsvais-api-token-validation-button';
import './components/mwsvais-usage-statistics';
import './components/mwsvais-video-control';
import './components/sw-product-video-script-control';
import './components/mwsvais-video-script-control';
import './components/mwsvais-textarea-field';
import './components/mwsvais-product-image-select';
import './components/mwsvais-form-of-address';
import './components/mwsvais-minute-account';
import './components/mwsvais-ai-bulk-edit';


import './module/sw-product'
import './module/sw-media-library'
import './module/sw-media-quickinfo-usage'
import './module/sw-extension/page/sw-extension-config'

import './components/mwsvais-video-template-select';

import './components/mwsvais-sw-product-image';

import ApiTestService from './service/api-test.service';
import FetchUsageStatisticsService from './service/fetch-usage-statistics.service';
import FetchVideoTemplatesService from "./service/fetch-video-templates.service";
import GenerateVideoService from './service/ai-video-manager.service'
import VideoScriptControlService from "./service/video-script-control.service";
import FetchMinuteAccountService from "./service/fetch-minute-account.service";

import NotificationWebhookService from "./service/notification-webhook.service";

import './util/mitt'
import ProductMediaSettings from './service/product-media-settings.service';


Shopware.Service().register('apiTest', () => {
    return new ApiTestService(
        Shopware.Application.getContainer('init').httpClient,
        Shopware.Service('loginService')
    );
});


Shopware.Service().register('videoScriptControl', () => {
    return new VideoScriptControlService(
        Shopware.Application.getContainer('init').httpClient,
        Shopware.Service('loginService')
    );

});

Shopware.Service().register('fetchVideoTemplates', () => {
    return new FetchVideoTemplatesService(
        Shopware.Application.getContainer('init').httpClient,
        Shopware.Service('loginService')
    );
});

Shopware.Service().register('fetchUsageStatistics', () => {
    return new FetchUsageStatisticsService(
        Shopware.Application.getContainer('init').httpClient,
        Shopware.Service('loginService')
    );
});

Shopware.Service().register('MwsVaisAiVideoManager', () => {
    return new GenerateVideoService(
        Shopware.Application.getContainer('init').httpClient,
        Shopware.Service('loginService')
    );
});

Shopware.Service().register('fetchMinute', () => {
    return new FetchMinuteAccountService(
        Shopware.Application.getContainer('init').httpClient,
        Shopware.Service('loginService')
    );
});
Shopware.Service().register('MwsVaisNotificationWebhookService', () => {
    const service = new NotificationWebhookService()
    service.init();
    return service;
})

Shopware.Service().register('MwsVaisProductMediaService', () => {
    return new ProductMediaSettings(
        Shopware.Application.getContainer('init').httpClient,
        Shopware.Service('loginService')
    )
})

Shopware.Locale.extend('de-DE', deDE);
Shopware.Locale.extend('en-GB', enGB);

Shopware.Service().get('MwsVaisNotificationWebhookService')