import './page/sw-product-detail';
import './page/sw-product-list';
import './component/sw-product-detail-ai-video';

Shopware.Module.register('sw-ai-video', {
    routeMiddleware(next, currentRoute) {
        const customRouteName = 'sw.product.detail.ai.video';

        if (
            currentRoute.name === 'sw.product.detail'
            && currentRoute.children.every((currentRoute) => currentRoute.name !== customRouteName)
        ) {
            currentRoute.children.push({
                name: customRouteName,
                path: '/sw/product/detail/:id/ai.video',
                component: 'sw-product-detail-ai-video',
                meta: {
                    parentPath: 'sw.product.index'
                }
            });
        }
        next(currentRoute);
    }
});