const ApiService = Shopware.Classes.ApiService;

export default class ApiTestService extends ApiService {
    constructor(httpClient, loginService, apiEndpoint = 'api-validation') {
        super(httpClient, loginService, apiEndpoint);
    }

    check(values) {
        const headers = this.getBasicHeaders();

        return this.httpClient.post(
            `${this.getApiBasePath()}/verify`,
            values,
            { headers }
        ).then((response) => {
            return ApiService.handleResponse(response);
        });
    }
}