<?php declare(strict_types=1);

namespace VideoAISoftware\Util;

use Symfony\Component\HttpKernel\Exception\AccessDeniedHttpException;

class ValidateWebhookSignature
{
    public static function validate(string $signatureFromRequestHeader, string $payload, string $apiToken): void
    {
        $hashedToken = hash('sha256', $apiToken);
        $expectedSignature = hash_hmac('sha256', $payload, $hashedToken);

        if (!hash_equals($expectedSignature, $signatureFromRequestHeader)) {
            throw new AccessDeniedHttpException('Invalid webhook signature');
        }
    }
}
